from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.api_admin.schemas.change_log import (
    get_change_log_list_request_schema, get_change_log_list_response_schema
)
from mail.payments.payments.core.actions.manager.change_log import GetChangeLogListManagerAction


class ChangeLogHandler(BaseAdminHandler):
    @request_schema(get_change_log_list_request_schema, location='query')
    @response_schema(get_change_log_list_response_schema)
    async def get(self):
        data = await self.run_action(GetChangeLogListManagerAction, await self.get_data())
        return self.make_response({'data': data}, get_change_log_list_response_schema)
