from sendr_aiohttp.handler import request_schema

from mail.payments.payments.api.schemas.document import uid_path_request_schema
from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.core.actions.manager.document import DownloadDocumentManagerAction


class DocumentHandler(BaseAdminHandler):
    @request_schema(uid_path_request_schema, location='match_info')
    async def get(self):
        headers, stream = await self.run_action(DownloadDocumentManagerAction, await self.get_data())
        return await self.make_stream_response(headers, stream)
