from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.schemas.path import uid_request_schema
from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.api_admin.schemas.manager import get_manager_role_list_response_schema
from mail.payments.payments.core.actions.manager.role import GetManagerRoleAction


class ManagerRoleHandler(BaseAdminHandler):
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(get_manager_role_list_response_schema)
    async def get(self):
        response_data = {
            'data': await self.run_action(GetManagerRoleAction, await self.get_data()),
        }
        return self.make_response(
            response_data,
            get_manager_role_list_response_schema,
        )
