from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.schemas.order import get_order_list_response_schema
from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.api_admin.schemas.order import (
    get_order_list_request_schema, get_order_list_response_schema_v2
)
from mail.payments.payments.core.actions.manager.order import GetOrderListManagerAction
from mail.payments.payments.core.entities.order import OrdersAdminData


class OrderHandler(BaseAdminHandler):
    @request_schema(get_order_list_request_schema, location='query')
    @response_schema(get_order_list_response_schema)
    async def get(self):
        data: OrdersAdminData = await self.run_action(GetOrderListManagerAction, await self.get_data())
        return self.make_response({'data': data.orders}, get_order_list_response_schema)


class OrderHandlerV2(BaseAdminHandler):
    @request_schema(get_order_list_request_schema, location='query')
    @response_schema(get_order_list_response_schema_v2)
    async def get(self):
        orders_data: OrdersAdminData = await self.run_action(GetOrderListManagerAction, await self.get_data())
        response_data = {
            'data': {
                'orders': orders_data.orders,
                'total': orders_data.stats.total,
                'found': orders_data.stats.found,
            }
        }
        result = self.make_response(response_data, get_order_list_response_schema_v2)
        return result
