from sendr_aiohttp.handler import response_schema

from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.api_admin.schemas.service import get_service_list_response_schema
from mail.payments.payments.core.actions.manager.service import GetServiceListManagerAction


class ServiceHandler(BaseAdminHandler):
    @response_schema(get_service_list_response_schema)
    async def get(self):
        data = await self.run_action(GetServiceListManagerAction, await self.get_data())
        return self.make_response({'data': data}, get_service_list_response_schema)
