from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.api_admin.schemas.transaction import (
    get_transaction_list_request_schema, get_transaction_list_response_schema, get_transaction_list_response_schema_v2
)
from mail.payments.payments.core.actions.manager.transaction import GetTransactionListManagerAction


class TransactionHandler(BaseAdminHandler):
    @request_schema(get_transaction_list_request_schema, location='query')
    @response_schema(get_transaction_list_response_schema)
    async def get(self):
        data = await self.run_action(GetTransactionListManagerAction, await self.get_data())
        return self.make_response({'data': data.transactions}, get_transaction_list_response_schema)


class TransactionHandlerV2(BaseAdminHandler):
    @request_schema(get_transaction_list_request_schema, location='query')
    @response_schema(get_transaction_list_response_schema_v2)
    async def get(self):
        transactions_data = await self.run_action(GetTransactionListManagerAction, await self.get_data())
        response_data = {
            'data': {
                'transactions': transactions_data.transactions,
                'total': transactions_data.stats.total,
                'found': transactions_data.stats.found,
            }
        }
        return self.make_response(response_data, get_transaction_list_response_schema_v2)
