from aiohttp import web

from sendr_tvm.qloud_async_tvm import TicketCheckResult
from sendr_tvm.server.aiohttp import get_tvm_restrictor

from mail.payments.payments.api.middlewares import TVMConfig, apply_debug_tvm_user_ticket
from mail.payments.payments.conf import settings


def tvm_check_func(request: web.Request, check_result: TicketCheckResult) -> bool:
    if settings.TVM_DEBUG_USER_TICKET:
        apply_debug_tvm_user_ticket(request, check_result)
    request['tvm'] = check_result
    return True


middleware_tvm = get_tvm_restrictor(TVMConfig, tvm_check_func, app_name='admin')
