from mail.payments.payments.api.routes.base import PrefixedUrl
from mail.payments.payments.api_admin.handlers.idm import (
    IDMAddRoleHandler, IDMGetAllRolesHandler, IDMInfoHandler, IDMRemoveRoleHandler
)


class IDMUrl(PrefixedUrl):
    PREFIX = '/admin/idm'


URLS = (
    IDMUrl('/info/', IDMInfoHandler, name='idm_info'),
    IDMUrl('/add-role/', IDMAddRoleHandler, name='idm_add_role'),
    IDMUrl('/remove-role/', IDMRemoveRoleHandler, name='idm_remove_role'),
    IDMUrl('/get-all-roles/', IDMGetAllRolesHandler, name='idm_get_all_roles'),
)
