from mail.payments.payments.api.routes.base import PrefixedUrl
from mail.payments.payments.api_admin.handlers.analytics import AnalyticsHandler
from mail.payments.payments.api_admin.handlers.change_log import ChangeLogHandler
from mail.payments.payments.api_admin.handlers.document import DocumentHandler
from mail.payments.payments.api_admin.handlers.manager import ManagerRoleHandler
from mail.payments.payments.api_admin.handlers.merchant import (
    BlockMerchantHandler, MerchantHandler, RecreateMerchantModerationHandler, SupportCommentMerchantHandler
)
from mail.payments.payments.api_admin.handlers.order import OrderHandler
from mail.payments.payments.api_admin.handlers.service import ServiceHandler
from mail.payments.payments.api_admin.handlers.transaction import TransactionHandler


class AdminV1Url(PrefixedUrl):
    PREFIX = '/admin/api/v1'


URLS = (
    AdminV1Url(r'/analytics', AnalyticsHandler, name='v1_admin_analytics'),
    AdminV1Url(r'/change_log', ChangeLogHandler, name='v1_admin_change_log'),
    AdminV1Url(r'/merchant', MerchantHandler, name='v1_admin_merchant'),
    AdminV1Url(
        r'/merchant/{uid:\d+}/support_comment',
        SupportCommentMerchantHandler,
        name='v1_admin_merchant_support_comment'
    ),
    AdminV1Url(r'/merchant/{uid:\d+}/block', BlockMerchantHandler, name='v1_admin_merchant_block'),
    AdminV1Url(r'/merchant/{uid:\d+}/moderation', RecreateMerchantModerationHandler,
               name='v1_admin_merchant_moderation'),
    AdminV1Url(r'/order', OrderHandler, name='v1_admin_order'),
    AdminV1Url(r'/transaction', TransactionHandler, name='v1_admin_transaction'),
    AdminV1Url(r'/document/{uid:\d+}/{path:.+}/download', DocumentHandler, name='v1_admin_document'),
    AdminV1Url(r'/manager_role/{uid:\d+}', ManagerRoleHandler, name='v1_admin_manager_role'),
    AdminV1Url(r'/service', ServiceHandler, name='v1_admin_service'),
)
