from mail.payments.payments.api.routes.base import PrefixedUrl
from mail.payments.payments.api_admin.handlers.merchant import MerchantHandlerV2
from mail.payments.payments.api_admin.handlers.order import OrderHandlerV2
from mail.payments.payments.api_admin.handlers.transaction import TransactionHandlerV2


class AdminV2Url(PrefixedUrl):
    PREFIX = '/admin/api/v2'


URLS = (
    AdminV2Url(r'/merchant', MerchantHandlerV2, name='v2_admin_merchant'),
    AdminV2Url(r'/transaction', TransactionHandlerV2, name='v2_admin_transaction'),
    AdminV2Url(r'/order', OrderHandlerV2, name='v2_admin_order'),
)
