from marshmallow import fields
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BasePaginatedRequestSchema, BaseSchema, SuccessResponseSchema
from mail.payments.payments.core.entities.enums import OperationKind


class ChangeLogSchema(BaseSchema):
    uid = fields.Integer()
    revision = fields.Integer()
    operation = EnumField(OperationKind, by_value=True)
    arguments = fields.Dict()
    info = fields.Dict()
    changed_at = fields.DateTime()


class GetChangeLogListRequestSchema(BasePaginatedRequestSchema):
    merchant_uid = fields.Integer(allow_none=True, missing=None)
    changed_at_from = fields.DateTime(allow_none=True, missing=None)
    changed_at_to = fields.DateTime(allow_none=True, missing=None)


class ChangeLogListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ChangeLogSchema, many=True)


get_change_log_list_request_schema = GetChangeLogListRequestSchema()
get_change_log_list_response_schema = ChangeLogListResponseSchema()
