from marshmallow import fields, post_load
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BaseSchema
from mail.payments.payments.api.schemas.fields import JSONNested
from mail.payments.payments.core.entities.enums import Role


class RoleSchema(BaseSchema):
    role = EnumField(Role, by_value=True)


class IDMRequestSchema(BaseSchema):
    domain_login = fields.String(load_from='login')
    role = JSONNested(RoleSchema)

    @post_load
    def unnest_role(self, data):
        data['role'] = data['role'].pop('role')
        return data


idm_request_schema = IDMRequestSchema()
