from marshmallow import fields, post_dump
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.moderation import ModerationSchema
from mail.payments.payments.core.entities.enums import ModerationRejectReason, ModerationStatus


class AdminModerationSchema(ModerationSchema):
    status = EnumField(ModerationStatus, by_value=True)
    updated = fields.DateTime()

    @post_dump
    def decode_reasons(self, data):
        if 'reasons' in data:
            reasons = data['reasons']
            assert isinstance(reasons, list)
            data['reasons'] = [ModerationRejectReason.get_reason_str(reason) for reason in reasons]
