from marshmallow import fields, validate
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BasePaginatedRequestSchema, BaseSchema
from mail.payments.payments.api.schemas.fields import NullableBoolean, QueryParamList
from mail.payments.payments.api.schemas.order import OrderSchema
from mail.payments.payments.core.entities.enums import PAY_METHODS, OrderKind, OrderSource, PayStatus, RefundStatus


class AdminOrderSchema(OrderSchema):
    trust_refund_id = fields.String()
    trust_payment_id = fields.String()


class GetOrderRequestSchema(BasePaginatedRequestSchema):
    sort_by = fields.String(
        validate=validate.OneOf(['created', 'updated', 'status']),
        default='updated'
    )
    descending = fields.Boolean(default=True, load_from='desc')

    created_from = fields.DateTime(load_from='lower_created_dt')
    created_to = fields.DateTime(load_from='upper_created_dt')
    updated_from = fields.DateTime(load_from='lower_updated_dt')
    updated_to = fields.DateTime(load_from='upper_updated_dt')
    uid = fields.Integer(load_from='merchant_uid')
    order_id = fields.Integer()
    parent_order_id = fields.Integer()
    original_order_id = fields.Integer()
    email_query = fields.String()
    pay_statuses = QueryParamList(EnumField(PayStatus, by_value=True))
    refund_statuses = QueryParamList(EnumField(RefundStatus, by_value=True))
    pay_method = fields.String(default=None, validate=validate.OneOf(PAY_METHODS))
    is_active = fields.Boolean()
    order_hash = fields.String()
    kinds = QueryParamList(EnumField(OrderKind, by_value=True))
    created_by_sources = QueryParamList(EnumField(OrderSource, by_value=True))
    service_ids = QueryParamList(fields.Integer(strict=True))
    subscription = NullableBoolean(missing=False)


class GetOrderListResponseV2DataSchema(BaseSchema):
    orders = fields.Nested(AdminOrderSchema, many=True)
    total = fields.Integer()
    found = fields.Integer()


class GetOrderListResponseV2Schema(BaseSchema):
    data = fields.Nested(GetOrderListResponseV2DataSchema)


get_order_list_request_schema = GetOrderRequestSchema()
get_order_list_response_schema_v2 = GetOrderListResponseV2Schema()
