from typing import Optional

from aiohttp.abc import StreamResponse

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.conf import settings
from mail.payments.payments.core.actions.interactions.developer import GetUidByKeyAction
from mail.payments.payments.core.exceptions import BaseCoreError


class BaseCoreException(object):
    pass


class BaseSDKHandler(BaseHandler):
    _uid: Optional[int] = None

    @property
    def uid(self) -> int:
        assert self._uid is not None
        return self._uid

    async def get_data(self) -> dict:
        data = await super().get_data()
        return {
            **data,
            'uid': self.uid,
        }

    async def _iter(self) -> StreamResponse:
        try:
            if settings.DEBUG:
                try:
                    self._uid = int(self.request.headers.get('X-Ya-Uid-Debug'))
                except (ValueError, TypeError):
                    pass

            if not self._uid:
                key = self.request.headers.get('Authorization')
                self._uid = await self.run_action(
                    GetUidByKeyAction,
                    {'key': key, 'user_ip': self.user_ip or '127.0.0.1'}
                )
        except BaseCoreError as e:
            self._core_exception_result(e)

        return await super()._iter()
