from aiohttp import web
from aiohttp.web_exceptions import HTTPException, HTTPNotFound

from mail.payments.payments.api.exceptions import APIException
from mail.payments.payments.api.middlewares import HandlerType
from mail.payments.payments.conf import settings


@web.middleware
async def middleware_request_checker(request: web.Request, handler: HandlerType) -> web.Response:
    route_name = request.match_info.route.name

    try:
        if route_name in settings.SDK_INTERNAL_PATHS and 'X-External-Request' in request.headers:
            raise HTTPNotFound
        return await handler(request)
    except HTTPException as e:
        if e.status_code >= 400:
            raise APIException(code=e.status_code, message=e.reason)
        else:
            raise e
