from mail.payments.payments.api.routes.base import PrefixedUrl
from mail.payments.payments.api_sdk.handlers.order import (
    CancelOrderHandler, ClearUnholdOrderHandler, CreateOrderHandler, DeactivateOrderHandler, OrderHandler,
    PayOfflineOrderHandler, RefundHandler
)


class Url(PrefixedUrl):
    PREFIX = '/v1'


V1_ROUTES = (
    Url(r'/order', CreateOrderHandler, name='v1_order_create'),
    Url(r'/order/{order_id:\d+}', OrderHandler, name='v1_order'),
    Url(r'/order/{order_id:\d+}/{operation:(clear|unhold)}', ClearUnholdOrderHandler, name='v1_order_clear_unhold'),
    Url(r'/order/{order_id:\d+}/deactivate', DeactivateOrderHandler, name='v1_order_deactivate'),
    Url(r'/order/{order_id:\d+}/pay_offline', PayOfflineOrderHandler, name='v1_order_pay_offline'),
    Url(r'/order/{order_id:\d+}/cancel', CancelOrderHandler, name='v1_order_cancel'),
    Url(r'/order/{order_id:\d+}/refund', RefundHandler, name='v1_refund_create'),
    Url(r'/order/{order_id:\d+}/refund/{refund_id:\d+}', RefundHandler, name='v1_refund_get'),
)
