from marshmallow import fields, validate

from mail.payments.payments.api.schemas.path import OrderIDRequestSchema


class RefundRequestSchema(OrderIDRequestSchema):
    refund_id = fields.Integer(required=True)


class ClearUnholdOrderSchema(OrderIDRequestSchema):
    operation = fields.String(required=True, validate=validate.OneOf(['clear', 'unhold']))


refund_request_schema = RefundRequestSchema()
clear_unhold_order_request_schema = ClearUnholdOrderSchema()
