import click

from mail.payments.payments.core.actions.service import CreateServiceAction
from mail.payments.payments.utils.cli import action_command


@click.command()
@click.argument('name', type=str)
@click.argument('tvm_id', type=int)
@click.argument('api_callback_url', type=str)
@click.argument('slug', type=str)
@click.option('--order_moderation_enabled', type=bool, default=True)
@click.option('--antifraud', type=bool, default=False)
@click.option('--hidden', type=bool, default=True)
@action_command
async def cli(
    name: str, tvm_id: int, api_callback_url: str, slug: str, order_moderation_enabled: bool = True,
    antifraud: bool = False, hidden: bool = True
) -> None:
    service = await CreateServiceAction(
        name=name,
        slug=slug,
        tvm_id=tvm_id,
        api_callback_url=api_callback_url,
        order_moderation_enabled=order_moderation_enabled,
        antifraud=antifraud,
        hidden=hidden
    ).run()
    print(f'Service {service.service_id} created')
