import click

from mail.payments.payments.core.actions.service_client import CreateServiceClientAction
from mail.payments.payments.utils.cli import action_command


@click.command()
@click.argument('service_id', type=int)
@click.argument('tvm_id', type=int)
@click.argument('api_callback_url', type=str)
@action_command
async def cli(service_id, tvm_id, api_callback_url):
    await CreateServiceClientAction(
        service_id=service_id,
        tvm_id=tvm_id,
        api_callback_url=api_callback_url,
    ).run()
