import logging

import click

from sendr_qlog import LoggerContext

from mail.payments.payments.core.actions.merchant.get import GetMerchantAction
from mail.payments.payments.core.entities.enums import NDS
from mail.payments.payments.interactions.trust import TrustProductionClient
from mail.payments.payments.utils.cli import action_command


@click.command()
@click.argument('uid', type=int)
@action_command
async def cli(uid):
    """
    Creates products for a partner

    Usage: manage.py init_partner <uid> <partner_id>
    """
    logger = LoggerContext(logging.getLogger(), {})
    trust_client = TrustProductionClient(logger, None)

    merchant = await GetMerchantAction(uid=uid).run()
    partner_id = merchant.client_id
    inn = merchant.data['organization']['inn']

    for nds in NDS:
        await trust_client.product_create(
            uid=uid,
            acquirer=merchant.acquirer,
            partner_id=partner_id,
            nds=nds.value,
            inn=inn,
        )
