import click
from sqlalchemy import and_, select

from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.actions.user_role.create import CreateOwnerUserRoleAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.storage.db.tables import merchants as t_merchants
from mail.payments.payments.storage.db.tables import user_roles as t_user_roles
from mail.payments.payments.utils.cli import action_command


@click.command()
@action_command
async def cli():
    db_engine = BaseAction.context.db_engine
    async with db_engine.acquire() as conn:
        from_clause = (
            t_merchants.join(
                t_user_roles,
                and_(
                    t_merchants.c.merchant_id == t_user_roles.c.merchant_id,
                    t_user_roles.c.role == MerchantRole.OWNER
                ),
                isouter=True
            )
        )
        query = (select([t_merchants.c.merchant_id, t_merchants.c.uid]).
                 select_from(from_clause).
                 where(t_user_roles.c.uid.is_(None)).
                 group_by(t_merchants.c.uid))

        rows = await conn.execute(query)

        for row in rows:
            await CreateOwnerUserRoleAction(merchant_id=row[0], user_uid=row[1]).run()
