import click
import yenv

from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.actions.init_client import InitClientAction
from mail.payments.payments.core.actions.init_products import InitProductsAction
from mail.payments.payments.core.exceptions import BaseCoreError
from mail.payments.payments.storage import StorageContext
from mail.payments.payments.utils.cli import action_command


@click.command()
@click.option('--uid', type=int)
@action_command
async def cli(uid=None):
    if yenv.type == 'production' and not click.confirm('Do you want to continue?'):
        return

    db_engine = BaseAction.context.db_engine
    async with StorageContext(db_engine) as storage:
        async for merchant in storage.merchant.find(uid=uid):
            merchant.person_id = None
            merchant.client_id = None
            merchant.load_data()
            if merchant.parent_uid is None:
                merchant.load_parent()

            try:
                if merchant.parent_uid is None:
                    await InitClientAction(merchant=merchant).run()

                await InitProductsAction(merchant=merchant).run()

                service_fees = set()
                async for service_merchant in storage.service_merchant.find(merchant.uid, with_service=True):
                    assert service_merchant.service
                    if service_fee := service_merchant.service.options.service_fee:
                        service_fees.add(service_fee)
                for service_fee in service_fees:
                    await InitProductsAction(merchant=merchant, service_fee=service_fee).run()

            except BaseCoreError as exc:
                print(f"Error: exception {exc} for uid {merchant.uid}")
