import click

from mail.payments.payments.core.actions.merchant.block import BlockMerchantAction
from mail.payments.payments.core.exceptions import MerchantNotFoundError
from mail.payments.payments.utils.cli import action_command


@click.command()
@click.argument('uid', type=int)
@click.option('--c/--no-c', default=True, show_default=True, help="Terminate / not terminate contract")
@action_command
async def cli(uid: int, c: bool) -> None:
    """Block merchant. By default also terminates contract."""
    try:
        merchant = await BlockMerchantAction(uid=uid, terminate_contract=c).run()
    except MerchantNotFoundError:
        print(f"Error: merchant {uid} not found")
    else:
        print(f"Merchant updated: blocked = {merchant.blocked}, contract_id = {merchant.contract_id}")
