from pprint import pprint

import click

from mail.payments.payments.utils.cli import action_command, load_action_cls


def parse_data(data):
    result = {}
    for item in data:
        name, value = item.split('=', maxsplit=1)
        try:
            value = eval(value, {}, {})
        except NameError:
            pass
        result[name] = value
    return result


@click.command(context_settings={'ignore_unknown_options': True})
@click.option('-d', '--dry-run', is_flag=True)
@click.argument('action', type=str)
@click.argument('data', nargs=-1, type=click.UNPROCESSED)
@action_command
async def cli(dry_run, action, data):
    action_cls = load_action_cls(action)
    click.echo(f'Action: {action_cls}')
    data = parse_data(data)
    pprint(data)
    if not dry_run:
        await action_cls(**data).run()
