import asyncio

import click
import uvloop
from aiohttp import web

from mail.payments.payments.api_admin.app import AdminApplication
from mail.payments.payments.utils.db import create_configured_engine
from mail.payments.payments.utils.logging import configure_logging


@click.command()
@click.option('--port', default=8002, help='Port number')
@click.option('--host', default='127.0.0.1', help='Bind address')
def cli(port, host):
    """Starts api web server.
    Usage: manage.py runserver --port=8002 --host=127.0.0.1
    """

    configure_logging()
    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    loop = asyncio.get_event_loop()

    db_engine = loop.run_until_complete(create_configured_engine())
    app = AdminApplication(db_engine=db_engine)

    web.run_app(app, port=port, host=host, loop=loop)
