import asyncio
import os

import click
import uvloop

from mail.payments.payments.storage.writers import PaymentsPushers
from mail.payments.payments.taskq.app import (
    FastModerationWorkerApplication, ModerationWorkerApplication, PaymentsWorkerApplication
)
from mail.payments.payments.utils.logging import configure_logging


@click.command()
@click.option('--port', default=8003, help='Port number')
@click.option('--host', default='127.0.0.1', help='Bind address')
@click.option(
    '--app', 'app_name',
    default=lambda: os.environ.get('PAYMENTS_WORKER_APP', 'payments'),
    type=click.Choice(['payments', 'moderation', 'fast-moderation']),
    help='Worker app to start',
)
def cli(port, host, app_name):
    """Starts specified worker web server.
    Usage: manage.py runworkers --port=8003 --host=127.0.0.1 --app=payments
    """
    configure_logging()
    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    loop = asyncio.get_event_loop()

    pushers = PaymentsPushers(loop=loop)

    if app_name == 'payments':
        app_cls = PaymentsWorkerApplication
    elif app_name == 'moderation':
        app_cls = ModerationWorkerApplication
    elif app_name == 'fast-moderation':
        app_cls = FastModerationWorkerApplication

    app = app_cls(pushers=pushers)
    app.start(host, port, loop=loop)
