import asyncio

import click
import uvloop

from mail.payments.payments.core.entities.task import Task, TaskType
from mail.payments.payments.storage import StorageContext
from mail.payments.payments.utils.db import create_configured_engine


async def start_moderation(uid: int) -> None:
    db_engine = await create_configured_engine()
    task = Task(
        task_type=TaskType.START_MODERATION,
        params=dict(merchant_uid=uid),
    )
    async with StorageContext(db_engine) as storage:
        await storage.task.create(task)


@click.command()
@click.argument('uid', type=int)
def cli(uid: int) -> None:
    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    loop = asyncio.get_event_loop()
    loop.run_until_complete(start_moderation(uid))
