from typing import ClassVar

from sendr_aiopg.action import BaseDBAction as BDBAction
from sendr_taskqueue.worker.storage.action import BaseAsyncDBAction

from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.entities.enums import TaskType
from mail.payments.payments.core.entities.not_fetched import NotFetchedType
from mail.payments.payments.storage import Storage, StorageContext
from mail.payments.payments.storage.exceptions import UserRoleNotFound


class BaseDBAction(BaseAsyncDBAction, BDBAction, BaseAction):
    transact: ClassVar[bool] = False
    storage_context_cls = StorageContext
    task_type = TaskType.RUN_ACTION

    @property
    def storage(self) -> Storage:
        return super().storage

    async def load_merchant_user(self) -> None:
        merchant_user = self.context.merchant_user
        if merchant_user is None:
            return
        if isinstance(merchant_user.user, NotFetchedType) or isinstance(merchant_user.user_role, NotFetchedType):
            try:
                user_role = await self.storage.user_role.get(
                    uid=merchant_user.user_uid,
                    merchant_id=merchant_user.merchant_id,
                    with_user=True,
                )
                merchant_user.user = user_role.user
                merchant_user.user_role = user_role
            except UserRoleNotFound:
                merchant_user.user = merchant_user.user_role = None
