from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.entities.common import CommonData
from mail.payments.payments.core.entities.enums import CommonDataType


class CreateCommonDataAction(BaseDBAction):
    def __init__(self, data_type: CommonDataType, payload: dict):
        super().__init__()
        self.data_type = data_type
        self.payload = payload

    async def handle(self) -> CommonData:
        return await self.storage.common_data.create(
            CommonData(
                data_type=self.data_type,
                payload=self.payload
            )
        )
