from typing import List, Optional, Tuple

from mail.payments.payments.core.actions.order.get_list import GetServiceMerchantOrderListAction
from mail.payments.payments.core.entities.customer_subscription import CustomerSubscription
from mail.payments.payments.core.entities.order import Order
from mail.payments.payments.storage.mappers.order.order import FindOrderParams


class GetCustomerSubscriptionListServiceMerchantAction(GetServiceMerchantOrderListAction):
    def __init__(self,
                 service_tvm_id: int,
                 service_merchant_id: int,
                 uid: Optional[int] = None,
                 subscription_id: Optional[int] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 ):
        super().__init__(
            service_tvm_id=service_tvm_id,
            service_merchant_id=service_merchant_id,
        )
        self.uid: Optional[int] = uid
        self.subscription_id: Optional[int] = subscription_id
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    def _get_find_order_params(self) -> FindOrderParams:
        return FindOrderParams(
            uid=self.uid,
            subscription_id=self.subscription_id,
            limit=self.limit,
            offset=self.offset,
            select_customer_subscription=True,
            with_customer_subscription=True,
        )

    async def handle(self) -> List[Tuple[CustomerSubscription, Order]]:  # type: ignore
        result = []
        orders = await super().handle()
        for order in orders:
            assert order.customer_subscription
            result.append((order.customer_subscription, order))

        return result
