from typing import Any, Optional

from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.mixins.auth_service_merchant import AuthServiceMerchantMixin
from mail.payments.payments.core.actions.order.pay import CorePayOrderAction
from mail.payments.payments.core.entities.order import Order
from mail.payments.payments.core.exceptions import CustomerSubscriptionNotFoundError
from mail.payments.payments.storage.exceptions import OrderNotFound


class StartCustomerSubscriptionServiceMerchantAction(AuthServiceMerchantMixin, BaseDBAction):
    transact = True

    def __init__(self, service_tvm_id: int, service_merchant_id: int, customer_subscription_id: int, **kwargs: Any):
        super().__init__()
        self.customer_subscription_id: Optional[int] = customer_subscription_id
        self.service_tvm_id: int = service_tvm_id
        self.service_merchant_id: int = service_merchant_id
        self.kwargs = kwargs

    async def _get_order(self) -> Order:
        try:
            assert self.uid is not None
            return await self.storage.order.get(uid=self.uid,
                                                customer_subscription_id=self.customer_subscription_id,
                                                with_customer_subscription=True)
        except OrderNotFound:
            raise CustomerSubscriptionNotFoundError

    async def handle(self) -> dict:
        return await CorePayOrderAction(
            uid=self.uid,
            order_getter=self._get_order,
            order_by_hash=False,
            **self.kwargs
        ).run()
