from typing import Optional

from mail.payments.payments.conf import settings
from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.entities.enums import AcquirerType, MerchantOAuthMode
from mail.payments.payments.core.entities.merchant import Merchant
from mail.payments.payments.core.entities.merchant_oauth import MerchantOAuth
from mail.payments.payments.core.entities.shop import Shop
from mail.payments.payments.core.exceptions import OAuthAbsentError


class GetMerchantOAuth(BaseDBAction):
    def __init__(self, acquirer: Optional[AcquirerType], merchant: Merchant, shop: Shop):
        super().__init__()
        self.merchant = merchant
        self.shop = shop
        self.acquirer = acquirer

    async def handle(self) -> Optional[MerchantOAuth]:
        assert self.shop.uid == self.merchant.uid
        acquirer = self.acquirer
        if acquirer is None:
            acquirer = self.merchant.acquirer

        if acquirer == AcquirerType.KASSA:
            try:
                assert self.shop.shop_id is not None
                return await self.storage.merchant_oauth.get_by_shop_id(uid=self.shop.uid, shop_id=self.shop.shop_id)
            except MerchantOAuth.DoesNotExist:
                if settings.MERCHANT_OAUTH_TRY_BY_MODE:
                    # TODO: PAYBACK-670: удалить эту ветку
                    mode = MerchantOAuthMode.from_shop_type(self.shop.shop_type)
                    try:
                        return await self.storage.merchant_oauth.get(
                            uid=self.shop.uid,
                            mode=mode,
                        )
                    except MerchantOAuth.DoesNotExist:
                        raise OAuthAbsentError
                raise OAuthAbsentError
        else:
            return None
