from typing import Optional

from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.enums import NDS
from mail.payments.payments.core.entities.merchant import Merchant


class InitProductsAction(BaseMerchantAction):
    skip_parent = False
    skip_data = False

    def __init__(self,
                 service_fee: Optional[int] = None,
                 uid: Optional[int] = None,
                 merchant: Optional[Merchant] = None,
                 ):
        super().__init__(uid=uid, merchant=merchant)
        self.service_fee = service_fee

    async def handle(self) -> None:
        assert (
            self.merchant is not None
            and self.merchant.organization.inn is not None
            and self.merchant.acquirer is not None
        )
        for nds in NDS:
            await self.clients.trust_production.product_create(
                uid=self.merchant.uid,
                acquirer=self.merchant.acquirer,
                partner_id=self.merchant.client_id,
                nds=nds.value,
                inn=self.merchant.organization.inn,
                service_fee=self.service_fee,
            )
        with self.logger:
            self.logger.context_push(uid=self.uid, service_fee=self.service_fee)
            self.logger.info('Products was created in production trust.')
