from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.entities.bank_requisites import BankRequisites
from mail.payments.payments.core.exceptions import BankNotFoundError
from mail.payments.payments.interactions.refs.exceptions import RefsClientNotFoundError


class BankRequisitesAction(BaseAction):
    def __init__(self, bic: str):
        super().__init__()
        self.bic: str = bic

    async def handle(self) -> BankRequisites:
        self.logger.context_push(bic=self.bic)
        try:
            return await self.clients.refs.cbrf_bank(self.bic)
        except RefsClientNotFoundError:
            self.logger.warning('CBRF refs: bank not found')
            raise BankNotFoundError
