from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.exceptions import DeveloperKeyAbsentError, DeveloperKeyAccessDenyError
from mail.payments.payments.interactions.developer import DeveloperKeyAccessDeny


class GetUidByKeyAction(BaseAction):
    def __init__(self, key: str, user_ip: str):
        super().__init__()
        self.key = key
        self.user_ip = user_ip

    async def handle(self) -> int:
        if not self.key:
            raise DeveloperKeyAbsentError

        try:
            return await self.clients.developer.check_key(self.key, self.user_ip)
        except DeveloperKeyAccessDeny:
            raise DeveloperKeyAccessDenyError
