from datetime import datetime
from typing import List, Optional

from mail.payments.payments.core.actions.manager.base import BaseManagerAction
from mail.payments.payments.core.entities.change_log import ChangeLog
from mail.payments.payments.core.entities.enums import Role


class GetChangeLogListManagerAction(BaseManagerAction):
    require_roles = (Role.ASSESSOR,)

    def __init__(self,
                 manager_uid: int,
                 merchant_uid: Optional[int] = None,
                 changed_at_from: Optional[datetime] = None,
                 changed_at_to: Optional[datetime] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 ):
        super().__init__(manager_uid=manager_uid)
        self.merchant_uid: Optional[int] = merchant_uid
        self.changed_at_from: Optional[datetime] = changed_at_from
        self.changed_at_to: Optional[datetime] = changed_at_to
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    async def handle(self) -> List[ChangeLog]:
        return [
            cl
            async for cl in self.storage.change_log.find(
                uid=self.merchant_uid,
                changed_at_from=self.changed_at_from,
                changed_at_to=self.changed_at_to,
                limit=self.limit,
                offset=self.offset,
            )
        ]
