from mail.payments.payments.core.actions.document import DownloadDocumentAction
from mail.payments.payments.core.actions.manager.base import BaseManagerAction
from mail.payments.payments.core.entities.enums import Role


class DownloadDocumentManagerAction(BaseManagerAction):
    require_roles = (Role.ADMIN,)

    def __init__(self,
                 manager_uid: int,
                 path: str,
                 uid: int,
                 ):
        super().__init__(manager_uid=manager_uid)
        self.path: str = path
        self.uid: int = uid

    async def handle(self):
        return await DownloadDocumentAction(
            path=self.path,
            uid=self.uid,
        ).run()
