from typing import List

from sendr_utils import alist

from mail.payments.payments.core.actions.manager.base import BaseManagerAction
from mail.payments.payments.core.entities.enums import Role
from mail.payments.payments.core.entities.service import Service


class GetServiceListManagerAction(BaseManagerAction):
    require_roles = (Role.ASSESSOR,)

    def __init__(self, manager_uid: int):
        super().__init__(manager_uid=manager_uid)

    async def handle(self) -> List[Service]:
        services = await alist(self.storage.service.find())
        return services
