from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.actions.init_client import InitClientAction
from mail.payments.payments.core.exceptions import MerchantCannotUpdateBalanceDataForChildError


class BalanceUpdateMerchantAction(BaseMerchantAction):
    transact = True
    skip_parent = True
    skip_data = True

    async def handle(self):
        if self.merchant.parent_uid is not None:
            raise MerchantCannotUpdateBalanceDataForChildError

        # Updating client and person. Merchant shouldn't change, not saving it
        await InitClientAction(merchant=self.merchant, save=False).run()
