from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.core.exceptions import CoreUserUIDMismatchError


class CheckUIDMatchAction(BaseAction):
    def __init__(self, uid: int):
        super().__init__()
        self.uid = uid

    async def check_merchant_user_roles(self):
        if self.merchant_user is None:
            return
        if self.merchant_user.user_uid != self.uid:
            raise CoreUserUIDMismatchError

    async def handle(self):
        pass
