from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.shop.get_or_ensure_default import GetOrEnsureDefaultShopAction
from mail.payments.payments.core.actions.user_role.create import CreateOwnerUserRoleAction
from mail.payments.payments.core.entities.enums import ShopType
from mail.payments.payments.core.entities.merchant import Merchant
from mail.payments.payments.core.entities.serial import Serial


class CreateMerchantEntityAction(BaseDBAction):
    transact = True

    def __init__(self, merchant: Merchant):
        super().__init__()
        self.merchant = merchant

    async def handle(self) -> Merchant:
        self.merchant = await self.storage.merchant.create(self.merchant)
        assert self.merchant.merchant_id is not None

        await self.storage.serial.create(Serial(uid=self.merchant.uid))
        await GetOrEnsureDefaultShopAction(uid=self.merchant.uid, default_shop_type=ShopType.PROD).run()
        await GetOrEnsureDefaultShopAction(uid=self.merchant.uid, default_shop_type=ShopType.TEST).run()

        await CreateOwnerUserRoleAction(
            merchant_id=self.merchant.merchant_id,
            user_uid=self.merchant.uid,
        ).run()

        return self.merchant
