from typing import Optional

from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.enums import MerchantDraftPolicy, MerchantRole
from mail.payments.payments.core.entities.merchant import Merchant


class GetMerchantAction(BaseMerchantAction):
    manual_load = True
    draft_policy = MerchantDraftPolicy.MERCHANT_DRAFT_ALLOWED
    required_merchant_roles = (MerchantRole.VIEWER,)

    def __init__(self,
                 uid: Optional[int] = None,
                 merchant: Optional[Merchant] = None,
                 token: Optional[str] = None,
                 for_update: Optional[bool] = None,
                 skip_parent: bool = False,
                 skip_data: bool = False,
                 skip_moderation: bool = False,
                 skip_oauth: bool = False,
                 skip_preregistration: bool = False,
                 skip_functionalities: bool = False,
                 ):
        super().__init__(uid=uid, merchant=merchant)
        self.token: Optional[str] = token
        self._skip_parent = skip_parent
        self._skip_data = skip_data
        self._skip_moderation = skip_moderation
        self._skip_oauth = skip_oauth
        self._for_update = for_update
        self._skip_registration = skip_preregistration
        self._skip_functionalities = skip_functionalities

    async def handle(self) -> Merchant:
        await self.load_merchant(
            uid=self.uid,
            merchant=self.merchant,
            token=self.token,
            skip_parent=self._skip_parent,
            skip_data=self._skip_data,
            skip_moderation=self._skip_moderation,
            skip_oauth=self._skip_oauth,
            skip_preregistration=self._skip_registration,
            skip_functionalities=self._skip_functionalities,
            for_update=self._for_update,
        )
        assert self.merchant is not None
        return self.merchant
