from typing import Optional

from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.enums import AcquirerType


class GetAcquirerMerchantAction(BaseMerchantAction):
    skip_parent = False
    skip_data = True
    skip_moderation = True

    async def handle(self) -> Optional[AcquirerType]:
        assert self.merchant is not None
        return self.merchant.acquirer
