from mail.payments.payments.core.actions.base.db import BaseDBAction
from mail.payments.payments.core.actions.interactions.developer import GetUidByKeyAction
from mail.payments.payments.core.actions.merchant.get import GetMerchantAction
from mail.payments.payments.core.entities.merchant import Merchant


class GetMerchantByKeyAction(BaseDBAction):
    def __init__(self, key: str, user_ip: str):
        super().__init__()
        self.key = key
        self.user_ip = user_ip

    async def handle(self) -> Merchant:
        uid = await GetUidByKeyAction(self.key, self.user_ip).run()
        return await GetMerchantAction(uid=uid).run()
