from typing import List, Optional

from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.merchant import Merchant


class GetMccInfoInTrustAction(BaseMerchantAction):
    skip_moderation = True
    skip_oauth = True
    skip_data = True

    def __init__(self, uid: Optional[int] = None,
                 merchant: Optional[Merchant] = None,
                 codes: Optional[List[int]] = None):
        super().__init__(uid=uid, merchant=merchant)
        self.codes: List[int] = codes or []

    async def handle(self):
        return await self.clients.trust_production.mcc_get(
            codes=self.codes,
            acquirer=self.merchant.acquirer,
            uid=self.merchant.uid
        )
