from typing import Optional

from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.enums import MerchantOAuthMode
from mail.payments.payments.core.entities.merchant import Merchant


class OAuthDeleteMerchantAction(BaseMerchantAction):
    skip_parent = True
    skip_data = True
    skip_moderation = True

    def __init__(self, merchant_oauth_mode: MerchantOAuthMode,
                 uid: Optional[int] = None,
                 merchant: Optional[Merchant] = None):
        super().__init__(uid=uid, merchant=merchant)
        self.merchant_oauth_mode = merchant_oauth_mode

    async def handle(self) -> None:
        self.logger.context_push(uid=self.uid, mode=self.merchant_oauth_mode)
        self.logger.warn('Attempted to delete token')
