from typing import Optional
from urllib.parse import urlencode

from mail.payments.payments.conf import settings
from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.merchant import Merchant
from mail.payments.payments.core.exceptions import ChildMerchantError
from mail.payments.payments.utils.helpers import uuid_hex, without_none


class OAuthStartMerchantAction(BaseMerchantAction):
    skip_parent = True
    skip_data = True
    skip_moderation = True

    def __init__(self, state: Optional[str] = None, uid: Optional[int] = None, merchant: Optional[Merchant] = None):
        super().__init__(uid=uid, merchant=merchant)
        self.state = state

    async def handle(self) -> str:
        assert self.merchant
        if self.merchant.parent_uid:
            raise ChildMerchantError

        # https://kassa.yandex.ru/developers/partners-api/oauth#request-code
        params = {
            'response_type': 'code',
            'client_id': settings.OAUTH_APP_ID,
            'device_id': f'payments-{uuid_hex()}',
            'state': self.state
        }

        return f"{settings.OAUTH_URL.rstrip('/')}/authorize?" + urlencode(without_none(params))
