from typing import List

from mail.payments.payments.core.actions.base.action import BaseAction
from mail.payments.payments.interactions.spark_suggest.entities import SparkSuggestItem


class MerchantSuggestAction(BaseAction):
    def __init__(self, query: str):
        super().__init__()
        self.query: str = query

    async def handle(self) -> List[SparkSuggestItem]:
        if not self.query:
            return []
        return [
            suggest_item
            for suggest_item in await self.clients.spark_suggest.get_hint(query=self.query)
            if suggest_item.inn
        ]
