import uuid

from mail.payments.payments.core.actions.base.merchant import BaseMerchantAction
from mail.payments.payments.core.entities.enums import MerchantRole
from mail.payments.payments.core.entities.merchant import Merchant


class MerchantTokenAction(BaseMerchantAction):
    transact = True
    for_update = True
    skip_parent = False
    skip_data = True

    async def _regenerate_token(self) -> Merchant:
        assert self.merchant
        self.merchant.token = str(uuid.uuid4())
        return await self.storage.merchant.save(self.merchant)


class GetMerchantTokenAction(MerchantTokenAction):
    required_merchant_roles = (MerchantRole.VIEWER,)

    async def handle(self) -> dict:
        assert self.merchant
        if not self.merchant.token:
            merchant = await self._regenerate_token()
            return {'token': merchant.token}

        return {'token': self.merchant.token}


class RegenerateMerchantTokenAction(MerchantTokenAction):
    required_merchant_roles = (MerchantRole.ADMIN,)

    async def handle(self) -> dict:
        assert self.merchant
        merchant = await self._regenerate_token()
        return {'token': merchant.token}
